# Deploy Social Media Bot on cPanel Shared Hosting

## Prerequisites
- cPanel account with Python support (Python 3.8+)
- SSH access (optional but recommended)
- File Manager access

## Step 1: Verify Python Support

1. Log into your cPanel
2. Look for "Setup Python App" or "Python Selector" in Software section
3. Verify Python 3.8+ is available
4. Note: If you don't see Python options, contact your hosting provider

## Step 2: Upload Your Files

### Option A: Using File Manager (Easier)
1. In cPanel, open **File Manager**
2. Navigate to your home directory (usually `/home/yourusername/`)
3. Create a new folder: `bot_poster`
4. Upload these files to `bot_poster/`:
   - `bot.py`
   - `scheduler.py`
   - `ai_content_generator.py`
   - `config.json` (with your real API keys)
   - `requirements.txt`
   - `post_history.json`
   - `cpanel_runner.py` (we'll create this)

### Option B: Using FTP
1. Use FileZilla or any FTP client
2. Connect to your cPanel FTP
3. Upload all files to `/home/yourusername/bot_poster/`

## Step 3: Setup Python Application

1. In cPanel, go to **Setup Python App**
2. Click **Create Application**
3. Configure:
   - **Python version**: 3.8 or higher
   - **Application root**: `bot_poster`
   - **Application URL**: Leave blank (not a web app)
   - **Application startup file**: `cpanel_runner.py`
   - **Application Entry point**: `application`

4. Click **Create**

## Step 4: Install Dependencies

### Method 1: Using cPanel Terminal
1. In cPanel, open **Terminal**
2. Run these commands:
```bash
cd ~/bot_poster
source /home/yourusername/virtualenv/bot_poster/3.X/bin/activate
pip install -r requirements.txt
```

### Method 2: Using SSH
```bash
ssh yourusername@yourdomain.com
cd ~/bot_poster
source /home/yourusername/virtualenv/bot_poster/3.X/bin/activate
pip install -r requirements.txt
```

Replace `3.X` with your actual Python version (e.g., `3.9`, `3.10`)

## Step 5: Add Gemini API Key

1. Get your Gemini API key from: https://makersuite.google.com/app/apikey
2. In cPanel Terminal or SSH:
```bash
cd ~/bot_poster
nano config.json
```
3. Add your Gemini API key to the config
4. Save and exit (Ctrl+X, then Y, then Enter)

## Step 6: Setup Cron Job for Scheduler

1. In cPanel, go to **Cron Jobs**
2. Under "Add New Cron Job":
   - **Common Settings**: Custom
   - **Minute**: `*`
   - **Hour**: `*`
   - **Day**: `*`
   - **Month**: `*`
   - **Weekday**: `*`
   - **Command**:
```bash
source /home/yourusername/virtualenv/bot_poster/3.X/bin/activate && cd /home/yourusername/bot_poster && python scheduler.py >> /home/yourusername/bot_poster/bot.log 2>&1
```

3. Click **Add New Cron Job**

**Important**: Replace:
- `yourusername` with your actual cPanel username
- `3.X` with your Python version

## Step 7: Keep Bot Running (Background Process)

Since cron runs every minute, we need a persistent process. Create a startup script:

### Using Screen (Recommended)
1. In Terminal/SSH:
```bash
cd ~/bot_poster
screen -S bot
source /home/yourusername/virtualenv/bot_poster/3.X/bin/activate
python scheduler.py
```
2. Press `Ctrl+A` then `D` to detach
3. Bot runs in background

To check status:
```bash
screen -r bot
```

### Using nohup (Alternative)
```bash
cd ~/bot_poster
source /home/yourusername/virtualenv/bot_poster/3.X/bin/activate
nohup python scheduler.py > bot.log 2>&1 &
```

## Step 8: Monitor Your Bot

### Check logs:
```bash
tail -f ~/bot_poster/bot.log
```

### Check if running:
```bash
ps aux | grep scheduler.py
```

### Stop the bot:
```bash
pkill -f scheduler.py
```

## Troubleshooting

### Bot stops running
- Check if your hosting allows long-running processes
- Some shared hosts kill processes after 5-10 minutes
- Consider using cron to restart every hour:
```bash
0 * * * * cd /home/yourusername/bot_poster && source /home/yourusername/virtualenv/bot_poster/3.X/bin/activate && pkill -f scheduler.py; python scheduler.py >> bot.log 2>&1 &
```

### Import errors
```bash
cd ~/bot_poster
source /home/yourusername/virtualenv/bot_poster/3.X/bin/activate
pip install --upgrade -r requirements.txt
```

### Permission denied
```bash
chmod +x ~/bot_poster/*.py
```

### Check Python path
```bash
which python
python --version
```

## Security Checklist

- [ ] `config.json` has correct permissions (600):
```bash
chmod 600 ~/bot_poster/config.json
```

- [ ] Never share your `config.json` file
- [ ] Keep API keys secure
- [ ] Regularly check `bot.log` for errors

## Alternative: Lightweight Cron-Based Posting

If your host doesn't allow persistent processes, use individual cron jobs for each post time:

```bash
# Monday 7:30 AM
30 7 * * 1 cd /home/yourusername/bot_poster && source /home/yourusername/virtualenv/bot_poster/3.X/bin/activate && python daily_post.py engagement_questions twitter

# Monday 12:00 PM
0 12 * * 1 cd /home/yourusername/bot_poster && source /home/yourusername/virtualenv/bot_poster/3.X/bin/activate && python daily_post.py learning_journey twitter
```

(Add all 24 posts from your schedule)

## Cost Considerations

- Most cPanel shared hosting: $3-10/month
- Ensure your plan includes:
  - Python support
  - SSH access
  - Cron jobs
  - Sufficient CPU/memory for scheduled tasks

## Recommended Hosts with Python Support

- A2 Hosting
- InMotion Hosting
- Hostinger
- Namecheap (some plans)
- SiteGround (Business plan+)

---

**Need help?** Check your hosting provider's documentation for "Python applications" or "Python hosting"
